const { src, dest, parallel , series , watch } = require('gulp');
// Gulp Sass
const sass = require('gulp-sass')(require('sass'));
const fileinclude = require('gulp-file-include');
const sourcemaps = require('gulp-sourcemaps');
const uglify = require('gulp-uglify');
const minify = require('gulp-minifier');
const strip = require('gulp-strip-comments');
const rtlcss = require('gulp-rtlcss');
const rename = require('gulp-rename');

const browserSync = require('browser-sync').create();
const reload = browserSync.reload;

// sass.compiler = require('node-sass'); // no-need for gulp-sass v5+

var node_path = '../..';


function html(cb) {
  src('src/html/**')
  .pipe(dest('dist/html'));

  cb();
}

// DO NOT uses {outputStyle: 'compressed'} in saas() it could conflict with RTLCSS  
function scss(cb) {
  src(['src/scss/*.scss'])
  // .pipe(sourcemaps.init())                               // If you want generate source map.
  .pipe(sass().on('error', sass.logError))                  
  // .pipe(sourcemaps.write('./'))                          // If you want generate source map.
  // .pipe(minify({ minify: true, minifyCSS: true }))       // If you want minified css.
  .pipe(dest('dist/assets/css'));

  src(['src/scss/*.scss', '!src/scss/style-email.scss'])
  // .pipe(sourcemaps.init())                               // If you want to generate source map.
  .pipe(sass().on('error', sass.logError))                  
  // .pipe(sourcemaps.write('./'))                          // If you want to generate source map.
  .pipe(rtlcss())
  .pipe(rename({ suffix: '.rtl' }))
  // .pipe(minify({ minify: true, minifyCSS: true }))       // If you want minified css.
  .pipe(dest('dist/assets/css'));

  // EDITORS
  src(['src/scss/editors/*.scss'])
  // .pipe(sourcemaps.init())                                           // If you want to generate source map.
  .pipe(sass().on('error', sass.logError))
  // .pipe(sourcemaps.write('./'))                                      // If you want to generate source map.
  // .pipe(minify({ minify: true, minifyCSS: true }))                   // If you want minified css.
  .pipe(dest('dist/assets/css/editors'));

  src(['src/scss/editors/*.scss'])
  // .pipe(sourcemaps.init())                                           // If you want to generate source map.
  .pipe(sass().on('error', sass.logError))
  // .pipe(sourcemaps.write('./'))                                      // If you want to generate source map.
  .pipe(rtlcss())
  .pipe(rename({ suffix: '.rtl' }))
  // .pipe(minify({ minify: true, minifyCSS: true }))                   // If you want minified css.
  .pipe(dest('dist/assets/css/editors'));

  src(['src/scss/libs/*.scss'])
  // .pipe(sourcemaps.init())                                           // If you want to generate source map.
  .pipe(sass().on('error', sass.logError))
  // .pipe(sourcemaps.write('./'))                                      // If you want to generate source map.
  // .pipe(minify({ minify: true, minifyCSS: true }))                   // If you want minified css.
  .pipe(dest('dist/assets/css/libs'));

  // SKINS
  src(['src/scss/skins/*.scss'])
  // .pipe(sourcemaps.init())                                           // If you want to generate source map.
  .pipe(sass().on('error', sass.logError))
  // .pipe(sourcemaps.write('./'))                                      // If you want to generate source map.
  // .pipe(minify({ minify: true, minifyCSS: true }))                   // If you want minified css.
  .pipe(dest('dist/assets/css/skins'));

  cb();
}

function js_scripts(cb) {
  src(['src/js/*.js','!src/js/bundle.js'])
  // .pipe(uglify())                        // If you minify the code.
  .pipe(dest('dist/assets/js'));

  src(['src/js/charts/*.js'])
  // .pipe(uglify())                        // If you minify the code.
  .pipe(dest('dist/assets/js/charts'));

  src(['src/js/apps/*.js'])
  // .pipe(uglify())                        // If you minify the code.
  .pipe(dest('dist/assets/js/apps'));

  cb();
}

function js_bundle(cb) {
  src('src/js/bundle.js')
  .pipe(fileinclude({
    prefix: '@@',
    basepath: '@file',
    context: { build: 'dist', nodeRoot: node_path }
  }))
  .pipe(strip())
  .pipe(minify({ minify: true, minifyJS: { sourceMap: false } }))     // Disable, if you dont want to minify bundle file.
  .pipe(dest('dist/assets/js'));

  src(['src/js/libs/**', '!src/js/libs/editors/skins/**'])
  .pipe(fileinclude({
    prefix: '@@',
    basepath: '@file',
    context: { build: 'dist', nodeRoot: node_path }
  }))
  .pipe(strip())
  .pipe(minify({ minify: true, minifyJS: { sourceMap: false } }))     // Disable, if you dont want to minify bundle file.
  .pipe(dest('dist/assets/js/libs'));

  src('src/js/libs/editors/skins/**').pipe(dest('dist/assets/js/libs/editors/skins'));

  cb();
}

function assets(cb){
  src(['src/images/**'])
  .pipe(dest('dist/images'));

  src(['src/assets/**', '!src/assets/js/**', '!src/assets/css/**'])
  .pipe(dest('dist/assets'));

  cb();
}

exports.build = series(html, scss, js_scripts, js_bundle, assets);

exports.develop = function() {

    browserSync.init({
        server: {
            baseDir: "./dist/",
            index: "html/index.html"
        },
        port:'5252'
    });

    watch(['src/scss/*.scss','src/scss/**'], scss)
    watch(['src/html/*.html','src/html/**/*.html']).on('change', series(html,reload))
    watch(['src/images/**', 'src/assets/**'], assets)
    watch(['src/js/*.js','src/js/charts/*.js', 'src/js/apps/*.js', '!src/js/bundle.js'], js_scripts)
    watch(['src/js/libs/**','src/js/bundle.js'], js_bundle)
};
